<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag;

use Exception;
use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagTable;

final class HashtagModel extends AbstractModel implements InterfaceHashtagGetter
{
    /**
     * getter interface
     */
    use TraitHashtagGetters;

    public function getTableClassName(): string
    {
        return HashtagTable::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | override the delete logic
    |--------------------------------------------------------------------------
    */

    public function delete(): bool
    {
        throw new Exception('No delete operations');
    }
}
